<?php
require 'config.php';

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die(json_encode(["error" => "Database connection failed: " . $conn->connect_error]));
}

// Check if a specific mobile number is requested
if (isset($_GET['mobile'])) {
    $mobile = $_GET['mobile'];

    // Fetch a specific record by mobile number
    $stmt = $conn->prepare("SELECT * FROM records WHERE mobile = ?");
    $stmt->bind_param("s", $mobile);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $record = $result->fetch_assoc();
        echo json_encode($record);
    } else {
        echo json_encode(["error" => "No user found"]);
    }

    $stmt->close();
} else {
    // Fetch all records
    $sql = "SELECT * FROM records";
    $result = $conn->query($sql);

    $records = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $records[] = $row;
        }
    }

    echo json_encode($records);
}

$conn->close();
?>